(function () {
    const tip = document.getElementById('tooltip');
    const cardsLayer = document.getElementById('cards');
    
    
    const DATA = {
        usa:   { label: "États-Unis",         global: 4830, dc: 176, ia: 28 },
        chine: { label: "Chine",              global: 8350, dc: 100, ia: 16 },
        ue:    { label: "Union européenne",   global: 3770, dc:  96, ia: 15 }
    };
    
      // --- Réglages d’échelle ---
    const BAR_MAX_PX = 240;
    const BOOST = { dc: 1.40, ia: 1.00 };
    const IA_MIN_PX = 5;
    const CLAMP_PADDING = 2;
    
    const MAX_GLOBAL = Math.max(...Object.values(DATA).map(d => d.global));
    
    function widthFor(kind, value, regionGlobal) {
        if (kind === 'global') {
          return Math.round((value / MAX_GLOBAL) * BAR_MAX_PX);
        }
        const base = regionGlobal > 0 ? (value / regionGlobal) * BAR_MAX_PX : 0;
        let w = base * (kind === 'dc' ? BOOST.dc : BOOST.ia);
        if (kind === 'ia' && value > 0) w = Math.max(w, IA_MIN_PX);
        const wGlobal = Math.round((regionGlobal / MAX_GLOBAL) * BAR_MAX_PX);
        w = Math.min(w, Math.max(0, wGlobal - CLAMP_PADDING));
        return Math.max(0, Math.round(w));
    }
    
      const clickableIds = ["usa", "chine", "ue"];
      const groups = clickableIds.map(id => document.getElementById(id)).filter(Boolean);
    
      function placeCardUnderGroup(cardEl, groupEl) {
        const wrapRect = cardsLayer.getBoundingClientRect();
        const rect = groupEl.getBoundingClientRect();
        const desiredLeft = rect.left + rect.width / 2 - wrapRect.left - cardEl.offsetWidth / 2;
        const desiredTop  = rect.bottom - wrapRect.top + 8;
        const left = Math.max(8, Math.min(desiredLeft, wrapRect.width - cardEl.offsetWidth - 8));
        const top  = Math.max(8, Math.min(desiredTop,  wrapRect.height - cardEl.offsetHeight - 8));
        cardEl.style.left = left + "px";
        cardEl.style.top  = top  + "px";
      }
    
      function createCard(id, d) {
        const el = document.createElement('div');
        el.className = 'data-card';
        el.id = 'card-' + id;
        el.innerHTML = `
          <div class="data-title">${d.label}</div>
          <div class="data-rows">
            ${buildRow('Consommation globale énergétique', d.global, 'TWh', 'global', d.global)}
            ${buildRow('Consommation des datacenters',    d.dc,     'TWh', 'dc',     d.global)}
            ${buildRow('Estimation de la part d’IA',      d.ia,     'TWh', 'ia',     d.global)}
          </div>
        `;
        return el;
      }
    
      function buildRow(labelText, value, unit, kind, regionGlobal) {
        const targetWidth = widthFor(kind, value, regionGlobal);
        return `
          <div class="row">
            <label>${labelText}</label>
            <div class="bar"><div class="fill ${kind}" data-target="${targetWidth}"></div></div>
            <div class="val">${new Intl.NumberFormat('fr-FR').format(value)} ${unit}</div>
          </div>
        `;
      }
    
      function toggleCardFor(id, groupEl) {
        const existing = document.getElementById('card-' + id);
        if (existing) { existing.remove(); groupEl.classList.remove('is-active'); return; }
        const d = DATA[id]; if (!d) return;
    
        const card = createCard(id, d);
        cardsLayer.appendChild(card);
        placeCardUnderGroup(card, groupEl);
    
        requestAnimationFrame(() => {
          card.classList.add('show');
          card.querySelectorAll('.fill').forEach(f => {
            f.style.width = '0px';
            void f.offsetWidth;
            f.style.width = f.dataset.target + 'px';
          });
        });
    
        groupEl.classList.add('is-active');
      }
    
      function repositionAllCards() {
        groups.forEach(g => {
          const card = document.getElementById('card-' + g.id);
          if (card) placeCardUnderGroup(card, g);
        });
      }
      window.addEventListener('resize', repositionAllCards);
    
      groups.forEach(group => {
        const name = group.id === "usa" ? "États-Unis"
                   : group.id === "chine" ? "Chine"
                   : group.id === "ue" ? "Union européenne"
                   : group.id;
    
        group.classList.add('country');
    
        if (!group.querySelector('title')) {
          const t = document.createElementNS('http://www.w3.org/2000/svg','title');
          t.textContent = name; group.appendChild(t);
        }
    
        group.addEventListener('mouseenter', () => {
          if (tip) { tip.textContent = name; tip.style.opacity = '1'; }
        });
        group.addEventListener('mousemove', e => {
          if (tip) { tip.style.left = (e.clientX + 8) + 'px'; tip.style.top = (e.clientY + 8) + 'px'; }
        });
        group.addEventListener('mouseleave', () => { if (tip) tip.style.opacity = '0'; });
    
        group.addEventListener('click', () => {        // ← stopPropagation retiré
          toggleCardFor(group.id, group);
        });
      });
    
    document.addEventListener('click', () => { if (tip) tip.style.opacity = '0'; });
    const btnSource = document.getElementById('btn-source-graph2');
    const modal = document.getElementById('source-graph2');
    const btnClose = modal ? modal.querySelector('.close-btn') : null;

    if (btnSource && modal && btnClose) {
        btnSource.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'false');
        });

        btnClose.addEventListener('click', () => {
            modal.setAttribute('aria-hidden', 'true');
        });

        modal.addEventListener('click', (e) => {
            if (e.target === modal) {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
                modal.setAttribute('aria-hidden', 'true');
            }
        });

    }
})();